<?php

/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

defined('ABSPATH') || exit;

/**
 * My Account navigation.
 *
 * @since 2.6.0
 */

do_action('woocommerce_account_navigation'); ?>
<header class="headers_dashboard col-12 col-lg-10 left">
	<?php if (ot_get_option('logo_blog_barsa')) : ?>
		<div class="header-logo right">
			<a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>">
				<img src="<?php echo ot_get_option('logo_blog_barsa'); ?>" alt="">
			</a>
		</div>
	<?php endif ?>
	<ul>
		<li title="بازگشت به فروشگاه"> <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>"><i class="fal fa-store"></i></a> </li>
		<li>
			<div id="cd-hamburger-menu"><i class="fal fa-bars"></i><a class="cd-img-replace" href="#0"></a></div>
		</li>
	</ul>
</header>
<div id="cd-shadow-layer"></div>
<style media="screen">
	#cd-shadow-layer {
		position: fixed;
		min-height: 100%;
		width: 100%;
		top: 0;
		left: 0;
		background: rgba(26, 30, 36, 0.6);
		cursor: pointer;
		z-index: 2;
		display: none;
	}

	#cd-shadow-layer.is-visible {
		display: block;
		-webkit-animation: cd-fade-in 0.3s;
		-moz-animation: cd-fade-in 0.3s;
		animation: cd-fade-in 0.3s;
	}
</style>
<div class="woocommerce-MyAccount-content col-12 col-lg-10">
	<?php
	/**
	 * My Account content.
	 *
	 * @since 2.6.0
	 */
	do_action('woocommerce_account_content');
	?>
</div>