<?php

/**
 * Template Name: User Profile
 * Template Post Type: page
 *
 * Allow users to update their profiles from Frontend.
 *
 */

/* Get user info. */
global $post; ?>
<!DOCTYPE html>
<html lang="fa">

<head>
    <meta charset="utf-8">
    <meta charset="<?php bloginfo('charset'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS2 Feed" href="<?php bloginfo('rss2_url'); ?>" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <?php
    wp_head();
    load_theme_textdomain('leora'); ?>
    <meta name="theme-color" content="<?php echo ot_get_option('colorbackmo', ''); ?>" />
    <style>
        .container {
            max-width: 1300px;
        }
    </style>
</head>

<body <?php body_class(); ?> id="body_blog">
    <?php if (is_user_logged_in()) : ?>
        <div class="container tab-panels">
            <div class="row">
                <div class="col- col-lg-3 pal_0 pr_0">
                    <?php get_template_part('themeplat/user/navigation', 'navigation'); ?>

                </div>
                <div class="col-12 col-lg-9 pal_0">
                    <header class="profile-user-header">
                        <?php
                        if (ot_get_option('logo_blog_barsa')) :
                        ?>
                            <div class="cd-logo">
                                <a href="<?php echo get_home_url(); ?>" title="<?php echo bloginfo('name'); ?>">
                                    <img src="<?php echo ot_get_option('logo_blog_barsa'); ?>">
                                </a>
                            </div>
                        <?php endif ?>
                        <ul>
                            <li>
                                <a href="<?php echo get_home_url(); ?>" title="<?php echo bloginfo('name'); ?>">
                                    <div class="tips">
                                        <i class="fal fa-home"></i>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </header>
                    <?php if (!empty($_GET['updated'])) : ?>
                        <div class="success not_profile_user"><?php _e('Profile successfully updated', 'leora'); ?></div>
                    <?php endif; ?>

                    <?php if (!empty($_GET['validation'])) : ?>

                        <?php if ($_GET['validation'] == 'emailnotvalid') : ?>
                            <div class="error not_profile_user"><?php _e('The given email address is not valid', 'leora'); ?></div>
                        <?php elseif ($_GET['validation'] == 'emailexists') : ?>
                            <div class="error not_profile_user"><?php _e('The given email address already exists', 'leora'); ?></div>
                        <?php elseif ($_GET['validation'] == 'passwordmismatch') : ?>
                            <div class="error not_profile_user"><?php _e('The given passwords did not match', 'leora'); ?></div>
                        <?php elseif ($_GET['validation'] == 'unknown') : ?>
                            <div class="error not_profile_user"><?php _e('An unknown error accurd, please try again or contant the website administrator', 'leora'); ?></div>
                        <?php endif; ?>

                    <?php endif; ?>
                    <?php
                    ?>
                    <?php get_template_part('themeplat/user/dashboard', 'dashboard'); ?>
                    <?php get_template_part('themeplat/user/edit-profile', 'edit-profile'); ?>
                    <?php get_template_part('themeplat/user/contact', 'contact'); ?>
                    <div id="panel-4" class="panel left_to_panle_user">
                        <?php _e('You have left the user panel!', 'leora'); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php
    else : ?>
        <div id="error-page-profile">
            <div class="wp-die-message">
                <?php _e('Sorry, you are not allowed to view drafts.', 'leora'); ?>
                <a href="<?php echo get_home_url(); ?>"><?php _e('return to home', 'leora'); ?></a>
            </div>
        </div>
    <?php
    endif;
    //Count Published Posts
    $Count_Posts = $wpdb->get_var("SELECT COUNT(ID) FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish'");
    //Count Published comments
    $comments_count = wp_count_comments();
    //Count Published authors
    $catauthors = array();
    $allposts = get_posts("cat=0&showposts=-100");
    if ($allposts) {
        foreach ($allposts as $authorpost) {
            $catauthors[$authorpost->post_author] = 1;
        }
        $authorss = count($catauthors);
    }
    ?>
    <script>
        "use strict";
        (function() {
            let menuIsOpen = true;
            let switchBtn = document.querySelector(".switch");
            let switchIcon = document.querySelector(".switch > i");

            function openMenu() {
                document.querySelector(".fixed-menu").classList.add("active");
                switchIcon.setAttribute("class", "fa fa-times-circle");
                switchBtn.style = "";
                menuIsOpen = true;
            }

            function closeMenu() {
                document.querySelector(".fixed-menu").classList.remove("active");
                switchIcon.setAttribute("class", "fa fa-caret-left");
                switchBtn.style.right = "101%";
                switchBtn.style.fontSize = "2.5rem";
                switchBtn.style.color = "#46b04a";
                menuIsOpen = false;
            }

            function autoPlusNum(el, finalNum) {
                let target = document.querySelector(el);
                let time = 1000;
                let speed = 10;
                let count = 0;
                let initial = 0;
                let step = finalNum / (time / speed);
                let timer = setInterval(() => {
                    count = count + step;
                    if (count >= finalNum) {
                        clearInterval(timer);
                        count = finalNum;
                    }
                    let text = Math.floor(count);
                    if (text === initial) return;
                    initial = text;
                    target.textContent = initial;
                }, 30);
            }

            function init() {
                setTimeout(() => {
                    autoPlusNum(".photos", <?php echo $Count_Posts; ?>);
                    autoPlusNum(".videos", <?php echo $comments_count->approved . ""; ?>);
                    autoPlusNum(".connections", <?php echo do_shortcode('[number_users]'); ?>);
                    autoPlusNum(".mixes", <?php echo $authorss; ?>);
                }, 500);
                switchBtn.addEventListener("click", function() {
                    menuIsOpen ? closeMenu() : openMenu();
                });
                window.addEventListener("resize", function() {
                    let ww = window.innerWidth;
                    let wh = window.innerHeight;
                    let icon = document.querySelector(".music > .pic");
                    ww >= 768 ? openMenu() : "";
                    wh <= 740 ?
                        (icon.style.display = "none") :
                        (icon.style.display = "block");
                });
            }
            init();
        })();
    </script>
    <?php wp_footer(); ?>
</body>

</html>