<?php
//Change Woocommerce Sort By Text
add_filter('woocommerce_catalog_orderby', 'wc_customize_product_sorting');

function wc_customize_product_sorting($sorting_options)
{
    $sorting_options = array(
        'menu_order' => __('مرتب سازی براساس', 'leora'),
        'popularity' => __('Bestselling', 'leora'),
        'rating'     => __('Most Popular', 'leora'),
        'date'       => __('the newest', 'leora'),
        'price'      => __('cheapest', 'leora'),
        'price-desc' => __('the most expensive', 'leora'),
    );

    return $sorting_options;
}

// show stock
function show_stock()
{
    global $product;
    if ($product->get_stock_quantity()) {
        if (number_format($product->get_stock_quantity(), 0, '', '') < 10) {
            echo  '<span class="nostock_quantity_denver">' . number_format($product->get_stock_quantity(), 0, '', '') . '</span>', ' عدد در انبار باقیست - پیش از اتمام بخرید';
        } else {
            echo ' موجود در انبار ', bloginfo('name'), '<span class="stock_quantity_denver">' . number_format($product->get_stock_quantity(), 0, '', '') . '</span>';
        }
    }
}
add_action('show_stock_woo_denver', 'show_stock', 10);
// change number related products
add_filter('woocommerce_output_related_products_args', 'change_number_related_products', 9999);

function change_number_related_products($args)
{
    $args['posts_per_page'] = 4;
    $args['columns'] = 4;
    return $args;
}
add_filter('woocommerce_sale_flash', 'tcore_percentage_sale', 10, 3);
function tcore_percentage_sale($text, $post, $product)
{

    $text = '<span>';

    $regular = $product->get_regular_price();
    $sale = $product->get_sale_price();
    if (isset($sale)) {
        $discount = ceil((($regular - $sale) / $regular) * 100);
    }

    $text .= $discount . '% ';

    $text .= '</span>';
    return $text;
}
add_filter('woocommerce_variable_price_html', 'mytheme_variation_price_format_min', 9999, 2);
function mytheme_variation_price_format_min($price, $product)
{
    $prices = $product->get_variation_prices(true);
    $min_price = current($prices['price']);
    $price = sprintf(__(' %1$s', 'woocommerce'), wc_price($min_price));
    return $price;
}
add_filter('woocommerce_variable_price_html', 'mytheme_variation_price_format', 10, 2);

function mytheme_variation_price_format($price, $product)
{

    // 1. Get min/max regular and sale variation prices

    $min_var_reg_price = $product->get_variation_regular_price('min', true);
    $min_var_sale_price = $product->get_variation_sale_price('min', true);
    $max_var_reg_price = $product->get_variation_regular_price('max', true);
    $max_var_sale_price = $product->get_variation_sale_price('max', true);

    // 2. New $price, unless all variations have exact same prices

    if (!($min_var_reg_price == $max_var_reg_price && $min_var_sale_price == $max_var_sale_price)) {
        if ($min_var_sale_price < $min_var_reg_price) {
            $price = sprintf(__('<del>%1$s</del><ins>%2$s</ins>', 'woocommerce'), wc_price($min_var_reg_price), wc_price($min_var_sale_price));
        } else {
            $price = sprintf(__(' %1$s', 'woocommerce'), wc_price($min_var_reg_price));
        }
    }

    // 3. Return $price

    return $price;
}
/**
 * remove sidebar
 */
remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
/**
 * Rename product data tabs
 */
add_filter('woocommerce_product_tabs', 'woo_rename_tabs', 98);
function woo_rename_tabs($tabs)
{

    $tabs['description']['title'] = __('Review', 'leora');
    $tabs['additional_information']['priority'] = 5;
    $tabs['additional_information']['title'] = __('Specifications', 'leora');
    $tabs['reviews']['title'] = __('Comments', 'leora');

    return $tabs;
}
function wc_get_customer_orders()
{

    // Get all customer orders
    $customer_orders = get_posts(array(
        'numberposts' => -1,
        'meta_key'    => '_customer_user',
        'meta_value'  => get_current_user_id(),
        'post_type'   => wc_get_order_types(),
        'post_status' => array_keys(wc_get_order_statuses()),
    ));

    $customer = wp_get_current_user();
    // Order count for a "loyal" customer
    $loyal_count = 3;
    // Text for our "thanks for loyalty" message
    $notice_text = sprintf('سلام %1$s &#x1f600; ما متوجه شده ایم که شما بیش از %2$s سفارش انجام داداید. – از اینکه مشتری وفادار هستید متشکریم!', $customer->display_name, $loyal_count);
    // Display our notice if the customer has at least 5 orders
    if (count($customer_orders) >= $loyal_count) {
        wc_print_notice($notice_text, 'notice');
    }
}
add_action('woocommerce_before_my_account', 'wc_get_customer_orders');
/**
 * Add a custom product data tab
 */
add_filter('woocommerce_product_tabs', 'woo_new_product_tab');
function woo_new_product_tab($tabs)
{
    // Adds the new tab
    $tabs['test_tab'] = array(
        'title'     => __('Short description', 'leora'),
        'priority'     => 50,
        'callback'     => 'woo_new_product_tab_content'
    );

    return $tabs;
}
function woo_new_product_tab_content()
{
    // custom short description
    require_once(get_template_directory() . '/woocommerce/single-product/tabs/custom-short-description.php');
}
// add to cart count
add_filter('woocommerce_add_to_cart_fragments', 'iconic_cart_count_fragments', 10, 1);
function iconic_cart_count_fragments($fragments)
{
    $fragments['div.header-cart-count'] = '<div class="header-cart-count">' . WC()->cart->get_cart_contents_count() . '</div>';
    return $fragments;
}
// add to cart
add_filter('woocommerce_product_single_add_to_cart_text', 'woo_custom_cart_button_text');
function woo_custom_cart_button_text()
{
    return __('Add to cart', 'leora');
}
add_filter('woocommerce_get_price_html', 'theme_price_free_zero_empty', 100, 2);

function theme_price_free_zero_empty($price, $product)
{

    /*if ( ” === $product->get_price() || 0 == $product->get_price() ) {
$price = رایگان;
}*/

    return $price;
}

// hidden price products
function mrcode_remove_outofstock_prices($price, $product)
{
    if (!$product->is_in_stock()) {
        $price = '';
    }
    return $price;
}

add_filter('woocommerce_variable_sale_price_html', 'mrcode_remove_outofstock_prices', 10, 2);
add_filter('woocommerce_variable_price_html', 'mrcode_remove_outofstock_prices', 10, 2);
add_filter('woocommerce_get_price_html', 'mrcode_remove_outofstock_prices', 10, 2);
function iconic_modify_theme_support()
{
    $theme_support = get_theme_support('woocommerce');
    $theme_support = is_array($theme_support) ? $theme_support[0] : array();

    unset($theme_support['single_image_width'], $theme_support['thumbnail_image_width']);

    remove_theme_support('woocommerce');
    add_theme_support('woocommerce', $theme_support);

    add_action('after_setup_theme', 'iconic_modify_theme_support', 10);
    $theme_support = get_theme_support('woocommerce');
    $theme_support = is_array($theme_support) ? $theme_support[0] : array();

    $theme_support['single_image_width'] = 800;
    $theme_support['thumbnail_image_width'] = 150;

    remove_theme_support('woocommerce');
    add_theme_support('woocommerce', $theme_support);
}

add_action('after_setup_theme', 'iconic_modify_theme_support', 10);
/**
 * Check if WC_SCRIPT_in_wp_footer does not exists and is_product function exists.
 */
if (class_exists('WooCommerce')) {
    if (!function_exists('WC_SCRIPT_in_wp_footer') && function_exists('is_product')) {
        /**
         * Add script in the WP footer page.
         */
        function WC_SCRIPT_in_wp_footer()
        {
            if (is_product() && !wp_is_mobile()) {
?>
                <script type="application/javascript">
                    jQuery('div.woocommerce-product-gallery.images').on('click', 'div.flex-viewport figure', function() {
                        jQuery(this).closest('.woocommerce-product-gallery').find('.woocommerce-product-gallery__trigger').trigger('click');
                    });
                </script>
        <?php
            }
        }
    }
    add_action('wp_footer', 'WC_SCRIPT_in_wp_footer');
}
/* ------------------------------------- Display normal prices and dashed prices in the shopping cart table ------------------------------------- */
add_filter('woocommerce_cart_item_price', 'theme_change_cart_table_price_display', 30, 3);

function theme_change_cart_table_price_display($price, $values, $cart_item_key)
{
    $slashed_price = $values['data']->get_price_html();
    $is_on_sale = $values['data']->is_on_sale();
    if ($is_on_sale) {
        $price = $slashed_price;
    }
    return $price;
}
/* --------------------------------- Sold------------------------------------- */


add_action('woocommerce_shop_loop_item_title', 'display_sold_out_loop_woocommerce');

function display_sold_out_loop_woocommerce()
{
    global $product;

    if (!$product->is_in_stock()) {
        echo '<span class="price soldout">' . __('unavailable !', 'leora') . '</span>';
    }
}

add_action('woocommerce_before_shop_loop_item', 'sales_timer_display');

function sales_timer_display()
{
    global $product;
    theme_product_sale_countdown();
}
/* ---------------------------------------------------------------------- */
if (!function_exists('yith_wcwl_selectively_hide_add_to_wishlist')) {
    function yith_wcwl_selectively_hide_add_to_wishlist($show)
    {
        /**
         * @var $product \WC_Product
         */
        global $product;

        if ($product instanceof WC_Product && has_term('tshirts-clothing', 'product_cat', $product->get_id())) {
            $show = false;
        }

        return $show;
    }

    add_filter('yith_wcwl_show_add_to_wishlist', 'yith_wcwl_selectively_hide_add_to_wishlist');
}
function display_yith_loop()
{
    function_exists('YITH_WCWL_Frontend') && YITH_WCWL_Frontend()->print_button();
}
add_action('woocommerce_after_shop_loop_item', 'display_yith_loop');
add_action('single_product_tools_denver', 'display_moreinformation_loop');
function display_moreinformation_loop()
{
    global $product;
    // product original
    if (original_product_get_meta('original_product_original')) { ?>
        <li>
            <a class="original_product" title="<?php _e('original', 'leora'); ?>"><?php _e('original', 'leora'); ?></a>
        </li>
    <?php
    }
    // free product
    if (original_product_get_meta('free_product')) { ?>
        <li>
            <a class="free_product" title="<?php _e('free delivery', 'leora'); ?>"><?php _e('free delivery', 'leora'); ?></a>
        </li>
    <?php
    }
    // product none
    if (original_product_get_meta('gift_product')) { ?>
        <li>
            <a class="gifts_product" title="<?php _e('Buy gifts', 'leora'); ?>"><?php _e('Buy gifts', 'leora'); ?></a>
        </li>
    <?php
    }
    // product Warranty
    if (original_product_get_meta('Warranty')) { ?>
        <li>
            <a class="Warranty_product" title="<?php _e('Warranty', 'leora'); ?>"><?php _e('Warranty', 'leora'); ?></a>
        </li>
    <?php
    }
}

/* ADD MY ORDER DASHBOARD
add_action( 'woocommerce_account_content', 'remove_dashboard_account_default', 5 );
function remove_dashboard_account_default() {
    add_action( 'woocommerce_account_content', 'custom_account_orders', 10 );
}


function custom_account_orders( $current_page ) {
    global $wp;

    if ( ! empty( $wp->query_vars ) ) {
        foreach ( $wp->query_vars as $key => $value ) {
            // Ignore pagename param.
            if ( 'pagename' === $key ) {
                continue;
            }

            if ( has_action( 'woocommerce_account_' . $key . '_endpoint' ) ) {
                do_action( 'woocommerce_account_' . $key . '_endpoint', $value );
                return;
            }
        }
    }

    $current_page    = empty( $current_page ) ? 1 : absint( $current_page );
    $customer_orders = wc_get_orders( apply_filters( 'woocommerce_my_account_my_orders_query', array(
        'customer' => get_current_user_id(),
        'page'     => $current_page,
        'paginate' => true,
    ) ) );

    wc_get_template(
        'myaccount/orders.php',
        array(
            'current_page'    => absint( $current_page ),
            'customer_orders' => $customer_orders,
            'has_orders'      => 0 < $customer_orders->total,
        )
    );
}
*/


/**
 * Edit my account menu order
 */

function my_account_menu_order()
{
    $menuOrder = array(
        'dashboard'          => __('Dashboard', 'leora'),
        'orders'             => __('Orders', 'leora'),
        'downloads'          => __('Download', 'leora'),
        'edit-address'       => __('Addresses', 'leora'),
        'edit-account'          => __('edit profile', 'leora'),
        'customer-logout'    => __('Logout', 'leora'),
    );
    return $menuOrder;
}
add_filter('woocommerce_account_menu_items', 'my_account_menu_order');

// ******************************** start theme_product_sale_countdown**************************************//
/**
 * ------------------------------------------------------------------------------------------------
 * Enqueue scripts
 * ------------------------------------------------------------------------------------------------
 */

if (!function_exists('theme_enqueue_scripts')) {
    add_action('wp_enqueue_scripts', 'theme_enqueue_scripts', 10000);

    function theme_enqueue_scripts()
    {
        $translations = array();

        wp_localize_script('theme-theme', 'theme_settings', $translations);
    }
}


// **********************************************************************//
// Enqueue scripts
// **********************************************************************//

if (!function_exists('theme_enqueue_script')) {
    function theme_enqueue_script($script_name)
    {
        if (theme_get_opt('combined_js')) return;
        wp_enqueue_script($script_name);
    }
}

/**
 * ------------------------------------------------------------------------------------------------
 * Product deal countdown
 * ------------------------------------------------------------------------------------------------
 */
if (!function_exists('theme_product_sale_countdown')) {
    function theme_product_sale_countdown()
    {
        global $product;
        $sale_date_end = get_post_meta($product->get_id(), '_sale_price_dates_to', true);
        $sale_date_start = get_post_meta($product->get_id(), '_sale_price_dates_from', true);

        if ((apply_filters('theme_sale_countdown_variable', false) || theme_get_opt('sale_countdown_variable')) && $product->get_type() == 'variable') {
            // Variations cache
            $cache          = apply_filters('theme_countdown_variable_cache', true);
            $transient_name = 'theme_countdown_variable_cache_' . $product->get_id();
            $available_variations = array();

            if ($cache) {
                $available_variations = get_transient($transient_name);
            }

            if (!$available_variations) {
                $available_variations = $product->get_available_variations();
                if ($cache) {
                    set_transient($transient_name, $available_variations, apply_filters('theme_countdown_variable_cache_time', WEEK_IN_SECONDS));
                }
            }

            if ($available_variations) {
                $sale_date_end = get_post_meta($available_variations[0]['variation_id'], '_sale_price_dates_to', true);
                $sale_date_start = get_post_meta($available_variations[0]['variation_id'], '_sale_price_dates_from', true);
            }
        }

        $curent_date = strtotime(date('Y-m-d H:i:s'));

        if ($sale_date_end < $curent_date || $curent_date < $sale_date_start) return;

        $timezone = 'GMT';

        if (apply_filters('theme_wp_timezone', false)) $timezone = wc_timezone_string();

        theme_enqueue_script('my-theme-countdown');

        echo '<div class="product-countdown"><div class="deal-text text" style="display:none"><span class="deal-text1">پیشنهاد شگفت انگیز</span><span class="deal-text2">فرصت باقی مانده </span>
    </div><div class="theme-timer" title="پیشنهاد شگفت انگیز" data-end-date="' . esc_attr(date('Y-m-d H:i:s', $sale_date_end)) . '" data-timezone="' . $timezone . '"></div></div>';
    }
}

if (!function_exists('theme_clear_countdown_variable_cache')) {
    function theme_clear_countdown_variable_cache($post_id)
    {
        if (!apply_filters('theme_countdown_variable_cache', true)) {
            return;
        }

        $transient_name = 'theme_countdown_variable_cache_' . $post_id;

        delete_transient($transient_name);
    }

    add_action('save_post', 'theme_clear_countdown_variable_cache');
}

// **********************************************************************//
// ! Function to get option from Redux Framework
// **********************************************************************//
if (!function_exists('theme_get_opt')) {
    function theme_get_opt($slug = '', $default = false)
    {
    }
}
// ******************************** end  theme_product_sale_countdown**************************************//

/**
 * Display the custom text field
 */
function cfwc_create_custom_field()
{
    $args = array(
        'id' => 'custom_text_field_title',
        'label' => __('Price affiliate marketing ', 'leora'),
        'class' => 'cfwc-custom-field',
        'desc_tip' => true,
        'description' => __('Enter the Price.', 'leora'),
    );
    woocommerce_wp_text_input($args);
}
add_action('woocommerce_product_options_general_product_data', 'cfwc_create_custom_field');
function cfwc_save_custom_field($post_id)
{
    $product = wc_get_product($post_id);
    $title = isset($_POST['custom_text_field_title']) ? $_POST['custom_text_field_title'] : '';
    $product->update_meta_data('custom_text_field_title', sanitize_text_field($title));
    $product->save();
}
add_action('woocommerce_process_product_meta', 'cfwc_save_custom_field');
// related and upsell
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
add_action('woocommerce_after_single_product', 'woocommerce_upsell_display');
add_action('woocommerce_after_single_product', 'woocommerce_output_related_products');
// sort_by_stock_status_then_alpha
add_action('woocommerce_product_query', 'sort_by_stock_status_then_alpha', 999);
function sort_by_stock_status_then_alpha($query)
{
    if (is_admin()) return;
    $query->set('meta_key', '_stock_status');
    $query->set('orderby', array('meta_value' => 'ASC'));
}

/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter('loop_shop_per_page', 'new_loop_shop_per_page', 20);

function new_loop_shop_per_page($cols)
{
    $cols = ot_get_option('item_arcive_product');
    return $cols;
}
/**
 * Display All Products Purchased by User
 */
add_shortcode('my_purchased_products', 'theme_products_bought_by_curr_user');

function theme_products_bought_by_curr_user()
{

    // GET CURR USER
    $current_user = wp_get_current_user();
    if (0 == $current_user->ID) return;

    // GET USER ORDERS (COMPLETED + PROCESSING)
    $customer_orders = get_posts(array(
        'numberposts' => -1,
        'meta_key'    => '_customer_user',
        'meta_value'  => $current_user->ID,
        'post_type'   => wc_get_order_types(),
        'post_status' => array_keys(wc_get_is_paid_statuses()),
    ));

    // LOOP THROUGH ORDERS AND GET PRODUCT IDS
    if (!$customer_orders) return;
    $product_ids = array();
    foreach ($customer_orders as $customer_order) {
        $order = wc_get_order($customer_order->ID);
        $items = $order->get_items();
        foreach ($items as $item) {
            $product_id = $item->get_product_id();
            $product_ids[] = $product_id;
        }
    }
    $product_ids = array_unique($product_ids);
    $product_ids_str = implode(",", $product_ids);
    return do_shortcode("[products ids='$product_ids_str']");
}

// get total sum of orders by a user in woocommerce
function get_customer_total_order()
{
    $customer_orders = get_posts(array(
        'numberposts' => -1,
        'meta_key'    => '_customer_user',
        'meta_value'  => get_current_user_id(),
        'post_type'   => array('shop_order'),
        'post_status' => array('wc-completed')
    ));

    $total = 0;
    foreach ($customer_orders as $customer_order) {
        $order = wc_get_order($customer_order);
        $total += $order->get_total();
    }

    return $total;
}

// Total purchase count by product for current user in Woocommerce
function wc_product_sold_count()
{
    if (!is_user_logged_in()) return;
    global $wpdb, $product;
    $user_id = get_current_user_id();
    $units_bought = $wpdb->get_var("
        SELECT SUM(woim2.meta_value)
        FROM {$wpdb->prefix}woocommerce_order_items AS woi
        INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta woim ON woi.order_item_id = woim.order_item_id
        INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta woim2 ON woi.order_item_id = woim2.order_item_id
        INNER JOIN {$wpdb->prefix}postmeta pm ON woi.order_id = pm.post_id
        INNER JOIN {$wpdb->prefix}posts AS p ON woi.order_id = p.ID
        WHERE woi.order_item_type LIKE 'line_item'
        AND p.post_type LIKE 'shop_order'
        AND p.post_status IN ('wc-completed','wc-processing')
        AND pm.meta_key = '_customer_user'
        AND pm.meta_value = '$user_id'
        AND woim.meta_key = '_product_id'
        AND woim2.meta_key = '_qty'
    ");
    if ($units_bought > 0) {
        $label = __('Units bought', 'leora'); // Label
        echo $units_bought;
    }
}
/**
 * Add go to vendor dashboard button to my account page dokan
 *
 */
function dokan_dashboard_btn()
{

    if (!dokan_is_user_seller(get_current_user_id())) {
        return;
    }

    printf(
        '<a href="%s">%s</a>',
        esc_url(dokan_get_navigation_url()),
        esc_html(apply_filters('dokan_set_go_to_vendor_dashboard_btn_text', __('فروشندگان', 'leora')))
    );
}

function custom_my_account_menu_items($items)
{
    unset($items['customer-logout']);
    return $items;
}
add_filter('woocommerce_account_menu_items', 'custom_my_account_menu_items');
remove_action('woocommerce_account_dashboard', 'dokan_set_go_to_vendor_dashboard_btn');
/**
 *  dokan sold name
 *
 */
function sold_by()
{
    ?>
    </a>
    <?php
    global $product;
    $seller = get_post_field('post_author', $product->get_id());
    $author  = get_user_by('id', $seller);
    $vendor = dokan()->vendor->get($seller);

    $store_info = dokan_get_store_info($author->ID);
    if (!empty($store_info['store_name'])) { ?>
        <span class="details_info_prod">
            <?php printf('فروشنده : <a href="%s">%s</a>', $vendor->get_shop_url(),  $vendor->get_shop_name());
            echo wp_kses_post(dokan_get_readable_seller_rating($author->ID));
            ?>
        </span>
<?php
    }
}
add_filter('woocommerce_product_tabs', 'dokan_remove_seller_info_tab', 50);
function dokan_remove_seller_info_tab($array)
{
    unset($array['seller']);
    return $array;
}
// Minimum CSS to remove +/- default buttons on input field type number
add_action( 'wp_head' , 'custom_quantity_fields_css' );
function custom_quantity_fields_css(){
    ?>
    <style>
    .quantity input::-webkit-outer-spin-button,
    .quantity input::-webkit-inner-spin-button {
        display: none;
        margin: 0;
    }
    .quantity input.qty {
        appearance: textfield;
        -webkit-appearance: none;
        -moz-appearance: textfield;
    }
    </style>
    <?php
}


add_action( 'wp_footer' , 'custom_quantity_fields_script' );
function custom_quantity_fields_script(){
    ?>
    <script type='text/javascript'>
    jQuery( function( $ ) {
        if ( ! String.prototype.getDecimals ) {
            String.prototype.getDecimals = function() {
                var num = this,
                    match = ('' + num).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);
                if ( ! match ) {
                    return 0;
                }
                return Math.max( 0, ( match[1] ? match[1].length : 0 ) - ( match[2] ? +match[2] : 0 ) );
            }
        }
        // Quantity "plus" and "minus" buttons
        $( document.body ).on( 'click', '.plus, .minus', function() {
            var $qty        = $( this ).closest( '.quantity' ).find( '.qty'),
                currentVal  = parseFloat( $qty.val() ),
                max         = parseFloat( $qty.attr( 'max' ) ),
                min         = parseFloat( $qty.attr( 'min' ) ),
                step        = $qty.attr( 'step' );

            // Format values
            if ( ! currentVal || currentVal === '' || currentVal === 'NaN' ) currentVal = 0;
            if ( max === '' || max === 'NaN' ) max = '';
            if ( min === '' || min === 'NaN' ) min = 0;
            if ( step === 'any' || step === '' || step === undefined || parseFloat( step ) === 'NaN' ) step = 1;

            // Change the value
            if ( $( this ).is( '.plus' ) ) {
                if ( max && ( currentVal >= max ) ) {
                    $qty.val( max );
                } else {
                    $qty.val( ( currentVal + parseFloat( step )).toFixed( step.getDecimals() ) );
                }
            } else {
                if ( min && ( currentVal <= min ) ) {
                    $qty.val( min );
                } else if ( currentVal > 0 ) {
                    $qty.val( ( currentVal - parseFloat( step )).toFixed( step.getDecimals() ) );
                }
            }

            // Trigger change event
            $qty.trigger( 'change' );
        });
    });
    </script>
    <?php
}
/* ------------------------------------------------- single product post action -------------*/
function action_woocommerce_after_single_product() { 
    get_template_part('themeplat/single/single-product-post', 'product_post');
}; 
add_action( 'woocommerce_after_single_product', 'action_woocommerce_after_single_product', 10, 0 ); 
