<?php
class Products_Categories extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'products-categories';
	}

	public function get_title()
	{
		return __('products categories', 'leora');
	}

	public function get_icon()
	{
		return 'eicon-product-categories';
	}

	public function get_categories()
	{
		return ['elementor-widget-be-shop'];
	}
	public function get_script_depends()
	{
		return ['elementor-hello-world'];
	}

	    protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'General', 'leora' ),
			]
		);
		$this->add_control(
			'grid_style',
			[
				'label' => __('Grid Style', 'leora'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__('Layout 1', 'leora'),
					'2' => esc_html__('Layout 2', 'leora'),
					'3' => esc_html__('Layout 3', 'leora'),
					'4' => esc_html__('Layout 4', 'leora'),
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'title', 'leora' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'title',
			]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .categories_4 .head_cat h4',
                'condition' => [
                    'grid_style' => ['4'],
                ]
			]
		);
		$this->add_control(
            'item_description_2',
            [
              'label' => __('Description', 'leora'),
              'type' => \Elementor\Controls_Manager::WYSIWYG,
              'default' => __('Default description', 'leora'),
              'placeholder' => __('Type your description here', 'leora'),
              'condition' => [
                'grid_style' => '4',
              ]
            ]
          );
		$this->add_control(
			'box_link',
			[
				'label' => __( 'Link', 'leora' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'leora' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'grid_style' => ['3'],
				]
			]
		);
        $this->end_controls_section();
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'leora' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'leora' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'leora' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'number',
			[
				'label' => __('number', 'leora'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 300,
			]
		);
		$repeater->add_control(
			'cat_count', [
				'label' => __( 'Category ID', 'leora' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '1' , 'leora' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => __('Icon', 'leora'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'leora' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
			'website_link',
			[
				'label' => __( 'Link', 'leora' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'leora' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'leora' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Title #1', 'leora' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'leora' ),
					],
					[
						'list_title' => __( 'Title #2', 'leora' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'leora' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();
     
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'general', 'leora' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'grid_style!' => ['1'],
				]
			]
		);
		$this->add_control(
			'color_lay2',
			[
				'label' => __( 'Title Color', 'leora' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00bfd6',
				
				'selectors' => [
					'{{WRAPPER}} .boxcat3 .woo-promotion__categories-title,.woo-promotion__categories-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .categories_4 .head_cat h4' => 'color: {{VALUE}}',
				],
				'condition' => [
					'grid_style' => ['1','2','4'],
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .categories_4',
			]
		);
		$this->add_control(
			'title_color_2',
			[
				'label' => __( 'Title Color', 'leora' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2a2a2a',
				
				'selectors' => [
					'{{WRAPPER}} .boxcat3 .title_tow,.boxcat1 .woo-promotion__category-name,.boxcat2 .service_content' => 'color: {{VALUE}}',
				],
				'condition' => [
					'grid_style' => ['1','2'],
				]
			]
		);
		$this->add_control(
			'hover_icon_color',
			[
				'label' => __( 'hover icon color', 'leora' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2a2a2a',
				
				'condition' => [
					'grid_style!' => ['3','4'],
				],
				'selectors' => [
					'{{WRAPPER}} .categories-2 .categories-item:hover .service_icon,.boxcat1 i,.boxcat2 .service_icon i' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'border_radius_cat',
			[
			  'label' => __( 'border radius', 'leora' ),
			  'type' => \Elementor\Controls_Manager::SLIDER,
			  'size_units' => [ 'px', '%' ],
			  'range' => [
				'px' => [
				  'min' => 0,
				  'max' => 100,
				  'step' => 1,
				],
				'%' => [
				  'min' => 0,
				  'max' => 100,
				],
			  ],
			  'default' => [
				'unit' => 'px',
				'size' => 15,
			  ],
			  'selectors' => [
				'{{WRAPPER}} .sbi_images .sbi_photo_wrap img,.sbi_images .sbi_photo_wrap a::after' => 'border-radius: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .categories_4 .categories-box' => 'border-radius: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .categories-2 .categories-item,.boxcat1 .woo-promotion__categories_container,.boxcat3 .jc-center' => 'border-radius: {{SIZE}}{{UNIT}};',
			]
			]
		  );
		  $this->add_control(
			'font_size_icon_cat',
			[
			  'label' => __( 'font size icon', 'leora' ),
			  'type' => \Elementor\Controls_Manager::SLIDER,
			  'size_units' => [ 'px', '%' ],
			  'range' => [
				'px' => [
				  'min' => 0,
				  'max' => 100,
				  'step' => 1,
				],
				'%' => [
				  'min' => 0,
				  'max' => 100,
				],
			  ],
			  'default' => [
				'unit' => 'px',
				'size' => 15,
			  ],
			  'condition' => [
				'grid_style!' => ['3','1','4'],
			],
			  'selectors' => [
				'{{WRAPPER}} .categories-2 .service_icon' => 'font-size: {{SIZE}}{{UNIT}};',
			]
			]
		  );
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_box',
			[
				'label' => __('box', 'leora'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'grid_style' => ['1'],
				]
			]
		);
		$this->add_control(
			'color',
			[
				'label' => __('Title', 'leora'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#373636',
				
				'selectors' => [
					'{{WRAPPER}} .woo-promotion__categories-title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_back',
			[
			  'label' => __('background color', 'leora'),
			  'type' => \Elementor\Controls_Manager::COLOR,
			  
			  'selectors' => [
				'{{WRAPPER}} .woo-promotion__categories_container' => 'background-color: {{VALUE}}',
			  ],
			  'default' => '#fff',
			]
		  );
		  $this->add_control(
			'border_radius__box',
			[
			  'label' => __( 'border radius', 'leora' ),
			  'type' => \Elementor\Controls_Manager::SLIDER,
			  'size_units' => [ 'px', '%' ],
			  'range' => [
				'px' => [
				  'min' => 0,
				  'max' => 100,
				  'step' => 1,
				],
				'%' => [
				  'min' => 0,
				  'max' => 100,
				],
			  ],
			  'default' => [
				'unit' => 'px',
				'size' => 0,
			  ],
			  'selectors' => [
				'{{WRAPPER}} .woo-promotion__categories_container' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
			  ],
			]
		  );
		$this->add_control(
			'title_color',
			[
				'label' => __('title', 'leora'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#9F9F9F',
				
				'selectors' => [
					'{{WRAPPER}} .woo-promotion__category-name' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
			  'label' => __('icon', 'leora'),
			  'type' => \Elementor\Controls_Manager::COLOR,
			  
			  'selectors' => [
				'{{WRAPPER}} .woo-promotion__category i,.woo-promotion__category-quantity' => 'color: {{VALUE}}',
			  ],
			  'default' => '#9F9F9F',
			]
		  );

		$this->end_controls_section();

	}


	protected function render()	{
		$settings = $this->get_settings_for_display();
        $bg_image = '';
        if (!empty($settings['bg_image']['id'])) {
            $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image']['id'], 'bg_image', $settings);
        } elseif (!empty($settings['bg_image']['url'])) {
            $bg_image = $settings['bg_image']['url'];
        }
        if (empty($bg_image) && 'classic' == $settings) {
            $print_bg = false;
        }
        if (!empty($bg_image)) {
            $this->add_render_attribute('background_image', 'style', [
                'background-image: url(' . $bg_image . ');',
            ]);
        }
		$grid_style = $settings['grid_style'];
			if (1 == $grid_style) {
				include(__DIR__ . '/template/categories/layout-1.php');

			} elseif (2 == $grid_style) {
				include(__DIR__ . '/template/categories/layout-2.php');

			} elseif (3 == $grid_style) {
				include(__DIR__ . '/template/categories/layout-3.php');

			} elseif (4 == $grid_style) {
				include(__DIR__ . '/template/categories/layout-4.php');

			} 
	}
}
