<?php

use \Elementor\Group_Control_Image_Size;

class Product_Slide extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'product-slide';
	}

	public function get_title()
	{
		return __('product slider', 'leora');
	}

	public function get_icon()
	{
		return ' eicon-posts-carousel';
	}

	public function get_categories()
	{
		return ['elementor-widget-be-shop'];
	}
	public function get_script_depends()
	{
		return ['elementor-hello-world'];
	}

	protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __('Content', 'leora'),
			]
		);
		$this->add_control(
			'grid_style',
			[
				'label' => __('Grid Style', 'leora'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__('Layout 1', 'leora'),
					'2' => esc_html__('Layout 2', 'leora'),
					'3' => esc_html__('Layout 3', 'leora'),
					'4' => esc_html__('Layout 4', 'leora'),
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __('Title', 'leora'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Edible and drinkable',
			]
		);
		$this->add_control(
			'title_show_more',
			[
				'label' => __('title show more', 'leora'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'View all offers',
			]
		);
		$this->add_control(
			'more_link',
			[
				'label' => __('more Link', 'leora'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'leora'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'leora-products',
			[
				'label' => esc_html__('Product Settings', 'leora'),
			]
		);
		$this->add_control(
			'my_plugin_product_grid_product_filter',
			[
				'label' => esc_html__('Filter By', 'leora'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'recent',
				'options' => [
					'recent' => esc_html__('Recent Products', 'leora'),
					'featured' => esc_html__('Featured Products', 'leora'),
					'best_selling' => esc_html__('Best Selling Products', 'leora'),
					'sale' => esc_html__('Sale Products', 'leora'),
					'top_rated' => esc_html__('Top Rated Products', 'leora'),
					'mixed_order' => esc_html__('Mixed order Products', 'leora'),
				],
			]
		);
		$this->add_control(
			'my_plugin_product_grid_products_count',
			[
				'label'   => __('Products Count', 'leora'),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 5,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);

		$this->add_control(
			'my_plugin_product_grid_categories',
			[
				'label' => esc_html__('Product Categories', 'leora'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => my_plugin_taxonomy_list(),
			]
		);

		$this->add_control(
			'custom_order',
			[
				'label' => esc_html__('Custom order', 'leora'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => esc_html__('Orderby', 'leora'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none'          => esc_html__('None', 'leora'),
					'ID'            => esc_html__('ID', 'leora'),
					'date'          => esc_html__('Date', 'leora'),
					'name'          => esc_html__('Name', 'leora'),
					'title'         => esc_html__('Title', 'leora'),
					'comment_count' => esc_html__('Comment count', 'leora'),
					'rand'          => esc_html__('Random', 'leora'),
				],
				'condition' => [
					'custom_order' => 'yes',
				]
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__('order', 'leora'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'DESC'  => esc_html__('Descending', 'leora'),
					'ASC'   => esc_html__('Ascending', 'leora'),
				],
				'condition' => [
					'custom_order' => 'yes',
				]
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style',
			[
				'label' => __('general', 'leora'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'background_color', 
			[
				'label' => __('background color', 'leora'),
				'type' => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .sli_6 .woo-list-slider-owl,.boxs_cover.layout-1 .ba_product,.sli_2 .listing__items__promotion-banner,.sli_3 .woo-list-slider-owl,.sli_4 .woo-swiper_specials,.sli_5 .woo-list-slider-owl' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .box_shop_4 .btn' => 'background-color: {{VALUE}}!important;',
				],
				'condition' => [
					'grid_style!' => ['3'],
				],
				
			]
		);
		$this->add_control(
			'button_color_price', 
			[
				'label' => __('color', 'leora'),
				'type' => \Elementor\Controls_Manager::COLOR,
				
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .box_shop_4 .woocommerce-Price-amount.amount' => 'color: {{VALUE}};',
				],
				'condition' => [
					'grid_style' => ['4'],
				],
				
			]
		);
		$this->add_control(
			'title_color_1',
			[
				'label' => __('Title Color', 'leora'),
				'type' => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .boxs_cover.layout-1 .content_banner-title,.sli_2 .listing__items-banner-title,.sli_3 header span,.sli_5 header span,.sli_6 header span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box_shop_3 .head_card_title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sli_3 .head_card_title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sli_6 .head_card_title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box_shop_4 .head_card_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_4',
			[
				'label' => __('color show more', 'leora'),
				'type' => \Elementor\Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .boxs_cover.layout-1 .content_banner-banner-button,.sli_2 .items--banner-more,.sli_3 .show___more,.sli_4 .content_banner-banner-button,.sli_5 .show___more,.sli_6 .show___more' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sli_2 .items--banner-more,.sli_3 .show___more,.sli_4 .content_banner-banner-button,.sli_5 .show___more,.sli_6 .show___more' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .box_shop_3 .head_card_more' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sli_3 .head_card_more' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sli_6 .head_card_more' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box_shop_4 .head_card_more' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'border_radius_pro_slid',
			[
				'label' => __( 'border radius', 'leora' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .sli_6 .woo-list-slider-owl,.ba_product.boxrud,.sli_2 .slide_pad,.sli_3 .woo-list-slider-owl,.sli_4 .woo-swiper_specials,.sli_5 .woo-list-slider-owl' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .box_shop_3 .arch_card_pro' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .box_shop_4 .card_cont' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
		$this->add_control(
			'border_radius_pro_slid_box',
			[
				'label' => __( 'border radius box', 'leora' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [ 
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .woo-product-box,.list-item-area-sim .item-area-simple' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
				],
				'condition' => [
					'grid_style!' => ['3','4'],
				],
			]
		);
		$this->add_control(
			'margin',
			[
				'label' => esc_html__( 'Margin', 'leora' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'condition' => [
					'grid_style' => '2',
				],
				'selectors' => [
					'{{WRAPPER}} .sli_6 .sec_list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_six',
			[
				'label' => __('style two', 'leora'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'grid_style' => '2',
				  ]
			]
		);
		$this->add_control(
			'sale_flash_six',
			[
				'label' => __('sale flash', 'leora'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#1e2f9d',
				
				'selectors' => [
					'{{WRAPPER}} .list-item-area-sim .bubble' => 'background-color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'sale_flash_six_text',
			[
				'label' => __('sale flash text', 'leora'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#fff',
				
				'selectors' => [
					'{{WRAPPER}} .list-item-area-sim .bubble' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{ ?>
		<script>
			$('.owl-carousel.focarousel5').owlCarousel({
				rtl: true,
				loop: false,
				margin: 0,
				dots: false,
				navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
				nav: true,
				responsive: {
					0: {
						items: 2,
						nav: false,
					},
					600: {
						items: 3,
						nav: false,
					},
					1000: {
						items: 5
					}
				}
			});
			$('.owl-carousel.focarousel').owlCarousel({
				rtl: true,
				loop: false,
				margin: 0,
				dots: false,
				navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
				nav: true,
				responsive: {
					0: {
						items: 2,
						nav: false,
					},
					600: {
						items: 3,
						nav: false,
					},
					1000: {
						items: 4
					}
				}
			});
		</script>
		<?php
		$settings = $this->get_settings_for_display();
		$settings           = $this->get_settings_for_display();
		$product_type       = $this->get_settings_for_display('my_plugin_product_grid_product_filter');
		$per_page           = $this->get_settings_for_display('my_plugin_product_grid_products_count');
		$custom_order_ck    = $this->get_settings_for_display('custom_order');
		$orderby            = $this->get_settings_for_display('orderby');
		$order              = $this->get_settings_for_display('order');
		$tabuniqid          = $this->get_id();
		$proslider          = $this->get_settings_for_display('proslider');
		$producttab          = $this->get_settings_for_display('producttab');
		$grid_style = $settings['grid_style'];
		// WooCommerce Category
		$args = array(
			'post_type'             => 'product',
			'post_status'           => 'publish',
			'ignore_sticky_posts'   => 1,
			'posts_per_page'        => $per_page,
		);

		switch ($product_type) {

			case 'sale':
				$args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
				break;

			case 'featured':
				$args['tax_query'][] = array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => 'featured',
					'operator' => 'IN',
				);
				break;

			case 'best_selling':
				$args['meta_key']   = 'total_sales';
				$args['orderby']    = 'meta_value_num';
				$args['order']      = 'desc';
				break;

			case 'top_rated':
				$args['meta_key']   = '_wc_average_rating';
				$args['orderby']    = 'meta_value_num';
				$args['order']      = 'desc';
				break;

			case 'mixed_order':
				$args['orderby']    = 'rand';
				break;

			default: /* Recent */
				$args['orderby']    = 'date';
				$args['order']      = 'desc';
				break;
		}

		// Custom Order
		if ($custom_order_ck == 'yes') {
			$args['orderby'] = $orderby;
			$args['order'] = $order;
		}

		$get_product_categories = $settings['my_plugin_product_grid_categories']; // get custom field value
		$product_cats = str_replace(' ', '', $get_product_categories);

		if ("0" != $get_product_categories) {
			if (is_array($product_cats) && count($product_cats) > 0) {
				$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
				$args['tax_query'][] = array(
					array(
						'taxonomy' => 'product_cat',
						'terms' => $product_cats,
						'field' => $field_name,
						'include_children' => false
					)
				);
			}
		}

		$products = new \WP_Query($args);
		if ($producttab == 'yes') {
			$m = 0;
			if (is_array($product_cats) && count($product_cats) > 0) {

				// Category retrive
				$catargs = array(
					'orderby'    => 'name',
					'order'      => 'ASC',
					'hide_empty' => true,
					'slug'       => $product_cats,
				);
				$prod_categories = get_terms('product_cat', $catargs);

				foreach ($prod_categories as $prod_cats) {
					$m++;
					$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
					$args['tax_query'] = array(
						array(
							'taxonomy' => 'product_cat',
							'terms' => $prod_cats,
							'field' => $field_name,
							'include_children' => false
						),
					);
					if ('featured' == $product_type) {
						$args['tax_query'][] = array(
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
							'operator' => 'IN',
						);
					}
				}
			}
		};
		if (is_array($product_cats) && (count($product_cats) > 0) && ($producttab == 'yes')) :
			$j = 0;
			foreach ($product_cats as $cats) :
				$j++;
				$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'product_cat',
						'terms' => $cats,
						'field' => $field_name,
						'include_children' => false
					)
				);
				if ('featured' == $product_type) {
					$args['tax_query'][] = array(
						'taxonomy' => 'product_visibility',
						'field'    => 'name',
						'terms'    => 'featured',
						'operator' => 'IN',
					);
				}
				$products = new \WP_Query($args);

				if ($products->have_posts()) :
		?>
			<?php endif;
			endforeach; ?>

		<?php else : ?>
			<!-- Set up your HTML -->
<?php
			$k = 1;
			if ($products->have_posts()) :
				$settings['background_color'] = $settings['background_color'] ?? '#fff';
				if (1 == $grid_style) {
					include(__DIR__ . '/template/product-slider/layout-1.php');
				} elseif (2 == $grid_style) {
					include(__DIR__ . '/template/product-slider/layout-2.php');
				} elseif (3 == $grid_style) {
					include(__DIR__ . '/template/product-slider/layout-3.php');
				} elseif (4 == $grid_style) {
					include(__DIR__ . '/template/product-slider/layout-4.php');
				} 
				wp_reset_postdata();
			endif;
		endif;
	}
}
