<?php

/**
 * Elementor Header Box Widget.
 *
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Typography;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Image_Size;


class Video_Digikala extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'video-digikala';
    }

    public function get_title()
    {
        return __('categorie digikala', 'leora');
    }

    public function get_icon()
    {
        return 'eicon-posts-masonry';
    }

    public function get_categories()
    {
        return ['elementor-widget-be'];
    }

    private function wpcap_get_all_post_categories($post_type)
    {

        $options = array();

        $taxonomy = 'category';

        if (!empty($taxonomy)) {
            // Get categories for post type.
            $terms = get_terms(
                array(
                    'taxonomy'   => $taxonomy,
                    'hide_empty' => false,
                )
            );
            if (!empty($terms)) {
                foreach ($terms as $term) {
                    if (isset($term)) {
                        if (isset($term->slug) && isset($term->name)) {
                            $options[$term->slug] = $term->name;
                        }
                    }
                }
            }
        }

        return $options;
    }

    private function grid_get_all_post_types()
    {
        $options = array();
        $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

        $args = array(
            'public' => true,
        );

        foreach (get_post_types($args, 'objects') as $post_type) {

            if (!isset($post_type->name)) {
                continue;
            }

            if (!isset($post_type->label)) {
                continue;
            }

            if (in_array($post_type->name, $exclude) === true) {
                continue;
            }

            $options[$post_type->name] = $post_type->label;
        }

        return $options;
    }

        protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
    {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__('Layout', 'leora'),
            ]
        );
        $this->add_control(
            'grid_style',
            [
                'label' => __('Grid Style', 'leora'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('Layout 1', 'leora'),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Title', 'leora'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'meta_data',
            [
                'label' => __('Meta Data', 'leora'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => ['date', 'comments'],
                'multiple' => true,
                'options' => [
                    'author' => __('Author', 'leora'),
                    'date' => __('Date', 'leora'),
                    'categories' => __('Categories', 'leora'),
                    'comments' => __('Comments', 'leora'),
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'meta_separator',
            [
                'label' => __('Separator Between', 'leora'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '/',
                'selectors' => [
                    '{{WRAPPER}} .wpcap-grid-container .wpcap-post .post-grid-meta span + span:before' => 'content: "{{VALUE}}"',
                ],
                'condition' => [
                    'meta_data!' => [],
                ],
            ]
        );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'leora'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
            ]
        );
        // Post categories
        $this->add_control(
            'post_categories',
            [
                'label'       => __('Categories', 'leora'),
                'label_block' => true,
                'type'        => \Elementor\Controls_Manager::SELECT2,
                'multiple'    => true,
                'options'     => $this->wpcap_get_all_post_categories('post'),

            ]
        );
        $this->add_control(
            'cat_id_lio',
            [
                'label' => __('Categories ID', 'leora'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__( 'Select ID Category to display the number of posts', 'leora' ),

            ]
        );
        $this->add_control(
            'advanced',
            [
                'label' => __('Advanced', 'leora'),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'leora'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'post_date',
                'options' => [
                    'post_date' => __('Date', 'leora'),
                    'post_title' => __('Title', 'leora'),
                    'rand' => __('Random', 'leora'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order', 'leora'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'asc' => __('ASC', 'leora'),
                    'desc' => __('DESC', 'leora'),
                ],
            ]
        );
        $this->add_control(
            'show_more',
            [
                'label' => __('Show more', 'leora'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'leora'),
                'label_off' => __('Hide', 'leora'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'website_link',
            [
                'label' => __('Link rss', 'leora'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'leora'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'grid_pagination',
            [
              'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __('Pagination', 'leora'),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',
            ]
          );
        $this->end_controls_section();
        $this->start_controls_section(
            'style_section_3',
            [
                'label' => __('General', 'leora'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'grid_style!' => '1',
                  ]
            ]
        );
        $this->add_control(
            'background_Color_vid',
            [
                'label' => __('background Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .larticle-2 .article_post2,.larticle-3 .article_post3' => 'background-color: {{VALUE}}',
                ],
                'default' => '#FFFFFF00',
            ]
        );
        $this->add_control(
            'border_radius',
            [
              'label' => __( 'border radius', 'leora' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px', '%' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
                ],
                '%' => [
                  'min' => 0,
                  'max' => 100,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 0,
              ],
              'selectors' => [
               '{{WRAPPER}} .article_post2,.article_post3 ' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
             ],
            ]
          );
        $this->end_controls_section();
        $this->start_controls_section(
            'widget_header',
            [
              'label' => __('header', 'leora'),
              'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
          );
          $this->add_control(
            'box_title',
            [
              'label' => __('title', 'leora'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#535353',
              
              'selectors' => [
                '{{WRAPPER}} .larticle-1 .section-heading,.article_post2 .article__title' => 'color: {{VALUE}}!important;',
              ],
            ]
          );
          $this->add_control(
            'head_background',
            [
              'label' => __('background color', 'leora'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => 'rgba(0, 0, 0, .04)',
              
              'selectors' => [
                '{{WRAPPER}} .larticle-1 .section-heading,.larticle-3 .section-heading_3' => 'background-color: {{VALUE}}!important;',
              ],
              'condition' => [
                'grid_style' => '1',
              ]
            ]
          );
          $this->add_control(
            'head_border',
            [
              'label' => __('border', 'leora'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#9e2358',
              
              'selectors' => [
                '{{WRAPPER}} .larticle-1 .section-heading::after,.larticle-3 .section-heading::after' => 'background-color: {{VALUE}}!important;',
              ],
              'condition' => [
                'grid_style' => '1',
              ]
            ]
          );
           $this->add_control(
            'border_radius_headmore',
            [
              'label' => __( 'border radius', 'leora' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px', '%' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
                ],
                '%' => [
                  'min' => 0,
                  'max' => 100,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 0,
              ],
              'selectors' => [
               '{{WRAPPER}} .larticle-1 .section-heading,.larticle-3 .section-heading_3' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
             ],
             'condition' => [
                'grid_style' => '1',
              ]
            ]
          );
          $this->add_control( 
            'Iconlayoutvidshow',
            [
              'label' => __('Show icon', 'leora'),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'label_on' => __('Show', 'leora'),
              'label_off' => __('Hide', 'leora'),
              'return_value' => 'yes',
              'default' => 'yes',
            ]
          );
          $this->add_control( 
            'Iconlayoutvid',
            [
                'label' => __('Icon', 'leora'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'Iconlayoutvidshow' => 'yes',
                  ]
            ]
        );
        $this->add_control(
			'image_logo',
			[
				'label' => esc_html__( 'Choose Image logo', 'leora' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->end_controls_section();
        $this->start_controls_section(
            'style_section_box',
            [
                'label' => __('box', 'leora'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'border_Color',
            [
                'label' => __('border Color', 'leora'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .article_post3 .block_articels,.article_post2 article' => 'border-color: {{VALUE}}',
                ],
                'default' => '#eee',
                'condition' => [
                    'grid_style!' => '1',
                  ]
            ]
        );
        $this->add_control(
            'border_radius_box',
            [
              'label' => __( 'border radius', 'leora' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px', '%' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
                ],
                '%' => [
                  'min' => 0,
                  'max' => 100,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 0,
              ],
              'selectors' => [
               '{{WRAPPER}} .article_post3 .article3_list_posts li .featured a,.larticle-3 .block_articels,.larticle-2 .article_post2 article,.larticle-1 .widget-item-content' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
             ],
            ]
          );
        $this->end_controls_section();
    }

    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();
        $bg_image = '';
        if (!empty($settings['bg_image']['id'])) {
            $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image']['id'], 'bg_image', $settings);
        } elseif (!empty($settings['bg_image']['url'])) {
            $bg_image = $settings['bg_image']['url'];
        }
        if (empty($bg_image) && 'classic' == $settings) {
            $print_bg = false;
        }
        
        if (!empty($bg_image)) {
            $this->add_render_attribute('background_image', 'style', [
                'background-image: url(' . $bg_image . ');',
            ]);
        }
        $settings = $this->get_settings();
        if (!empty($settings['grid_pagination'])) {
            $paged         = get_query_var('paged');
            if (empty($paged)) {
                $paged         = get_query_var('page');
            }
            $args['paged'] = $paged;
        }
        if (empty($settings['title']) && empty($settings['description']) && empty($settings['button']) && 'none' == $settings) {
            $print_content = false;
        }
        $grid_style = $settings['grid_style'];

        $posts_per_page = (!empty($settings['posts_per_page']) ?  $settings['posts_per_page'] : 3);
        $cats = is_array($settings['post_categories']) ? implode(',', $settings['post_categories']) : $settings['post_categories'];
        $query_args = array(
            'posts_per_page'     => absint($posts_per_page),
            'post__not_in'          => get_option('sticky_posts'),
            'ignore_sticky_posts'   => true,
            'paged' => $paged,
            'category_name'     => $cats
        );
        // Order by.
        if (!empty($settings['orderby'])) {
            $query_args['orderby'] = $settings['orderby'];
        }
        // Order .
        if (!empty($settings['order'])) {
            $query_args['order'] = $settings['order'];
        }
        $all_posts = new \WP_Query($query_args);
        if ($all_posts->have_posts()) :

            if (1 == $grid_style) {

                include(__DIR__ . '/article/video-digi.php');
            }
            wp_reset_postdata();
        endif;
    }

    protected function render_meta()
    {
        $settings = $this->get_settings();
        $meta_data = $settings['meta_data'];
        if (empty($meta_data)) {
            return;
        }
?>
        <div class="post-grid-meta">
            <?php
            if (in_array('date', $meta_data)) { ?>
                <span class="post-author"><?php echo apply_filters('the_date', get_the_date(), get_option('date_format'), '', ''); ?></span>
            <?php
            }

            if (in_array('categories', $meta_data)) {
                $categories_list = get_the_category_list(esc_html__(', ', 'leora'));

                if ($categories_list) {
                    printf('<span class="post-categories">%s</span>', $categories_list); // WPCS: XSS OK.
                }
            }

            if (in_array('comments', $meta_data)) { ?>
                <span class="post-comments"><?php comments_number(); ?></span>

            <?php
            }
            ?>
        </div>
        <?php

    }
    protected function render_thumbnail()
    {

        $settings = $this->get_settings();

        $show_image = $settings['show_image'];

        if ('yes' !== $show_image) {
            return;
        }

        $post_thumbnail_size = $settings['post_thumbnail_size'];

        if (has_post_thumbnail()) :  ?>
            <div class="post-grid-thumbnail">
                <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail($post_thumbnail_size); ?>
                </a>
            </div>
<?php endif;
    }
}
