<?php

/**
 * Elementor Box Content Responsive Widget.
 *
 */

use \Elementor\Group_Control_Image_Size;


class Slider extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'slider';
  }

  public function get_title()
  {
    return __('slider', 'leora');
  }

  public function get_icon()
  {
    return 'eicon-slides';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }
      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'leora'),
      ]
    );
    $this->add_control(
      'grid_style',
      [
        'label' => __('Grid Style', 'leora'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('Layout 1', 'leora'),
          '2' => esc_html__('Layout 2', 'leora'),
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content_section',
      [
        'label' => __('Content', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'list_title',
      [
        'label' => __('Title', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'image',
      [
        'label' => __('Choose Image slider', 'leora'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_group_control(
      \Elementor\Group_Control_Image_Size::get_type(),
      [
        'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
        'default' => 'full',
        'separator' => 'none',
      ]
    );

    $repeater->add_control(
      'website_link',
      [
        'label' => __('Link', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'list',
      [
        'label' => __('Repeater List', 'leora'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'list_title' => __('Title #1', 'leora'),
          ],
          [
            'list_title' => __('Title #2', 'leora'),
          ],
        ],
        'title_field' => '{{{ list_title }}}',
      ]
    );
    $this->add_control(
			'image1',
			[
				'label' => __( 'Choose Image', 'leora' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'default' => 'full',
				'separator' => 'none',
			]
        );
		$this->add_control(
			'website_link1',
			[
			  'label' => __( 'Link', 'leora' ),
			  'type' => \Elementor\Controls_Manager::URL,
			  'placeholder' => __( 'https://your-link.com', 'leora' ),
			  'show_external' => true,
			  'default' => [
				'url' => '',
				'is_external' => true,
				'nofollow' => true,
			  ],
			]
		  );
		$this->add_control(
			'image2',
			[
				'label' => __( 'Choose Image', 'leora' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'website_link2',
			[
			  'label' => __( 'Link', 'leora' ),
			  'type' => \Elementor\Controls_Manager::URL,
			  'placeholder' => __( 'https://your-link.com', 'leora' ),
			  'show_external' => true,
			  'default' => [
				'url' => '',
				'is_external' => true,
				'nofollow' => true,
			  ],
			]
		  );
    $this->end_controls_section();
    $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'general', 'leora' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'dots_color',
			[
				'label' => __( 'dots', 'leora' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#fc0',
				
				'selectors' => [
					'{{WRAPPER}} .owl-dots .owl-dot.active span' => 'background: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'border_radius_amz_cat',
			[
				'label' => __( 'border radius', 'leora' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .box_radius_slid' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .sec-casino-games' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_2',
			[
				'label' => __( 'style 2', 'leora' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' => __( 'button', 'leora' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#fc0',
				
				'selectors' => [
					'{{WRAPPER}} .sec-casino-games-slider .bth-slider' => 'background: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'button_color_text',
			[
				'label' => __( 'button text', 'leora' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .sec-casino-games-slider .bth-slider' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->end_controls_section();
  }


  protected function render()
  {
    $settings = $this->get_settings(); 
    $grid_style = $settings['grid_style'];
		?>
    <script>
      $('.owl-two.owl-carousel').owlCarousel({
        items: 1,
        rtl: true,
        lazyLoad: true,
        autoWidth: false,
        navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
        nav: true,
        dots: true,
        autoplay: true,
        loop: true,
        responsive: {
          0: {
            items: 1,
            nav: false,
          },
          600: {
            items: 1,
            nav: false,
          },
          1000: {
            items: 1
          }
        }
      });
    </script>
    
		<?php
				if (1 == $grid_style) {
					include(__DIR__ . '/slider/layout-1.php');

				} elseif (2 == $grid_style) {
					include(__DIR__ . '/slider/layout-2.php');

				}
				wp_reset_postdata();
  }
}
