<?php
/**
 * Image box
 *
 */

use \Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Product_Introduction extends \Elementor\Widget_Base {

	public function get_name() {
		return 'product-introduction';
	}

	public function get_title() {
		return __( 'product introduction', 'leora' );
	}

	public function get_icon() {
		return 'eicon-call-to-action';
	}

	public function get_categories() {
		return [ 'elementor-widget-be' ];
	}

	protected function register_controls()
	{
		$this->init_content_general_controls();
	}
   
	protected function init_content_general_controls() {
		$this->start_controls_section(
			'content_section',
			[
			  'label' => __( 'Content', 'leora' ),
			  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		  );
		  $this->add_control(
			'title',
			[
				'label' => __( 'Title', 'leora' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'title',
			]
		);
		$this->add_control(
			'title_more',
			[
				'label' => __( 'Title more', 'leora' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'title more',
			]
		);
		$this->add_control(
			'item_description',
			[
				'label' => __( 'Description', 'leora' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'Default description', 'leora' ),
				'placeholder' => __( 'Type your description here', 'leora' ),
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'leora' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image_align',
			[
				'label' => __( 'Alignment', 'leora' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'leora' ),
						'icon' => 'fa fa-align-left',
					],
					'right' => [
						'title' => __( 'Right', 'leora' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'Right',
				'toggle' => true,
			]
		);
		$this->add_control(
			'website_link',
			[
				'label' => __( 'Link', 'leora' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'leora' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'general', 'leora' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'border_radius_introduction',
			[
				'label' => __( 'border radius', 'leora' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .product-introduction section' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
		$this->add_control(
			'height__introduction',
			[
				'label' => __( 'height', 'leora' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'selectors' => [
					'{{WRAPPER}} .product-introduction section .box-img , .product-introduction,.product-introduction .content-introduction' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
            'background_color',
            [
              'label' => __( 'background color', 'leora' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#fff',
              
              'selectors' => [
                '{{WRAPPER}} .product-introduction section' => 'background-color: {{VALUE}}',
              ],
            ]
          );
		  $this->add_control(
            'title_color',
            [
              'label' => __( 'title', 'leora' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#212121',
              
              'selectors' => [
                '{{WRAPPER}} .wid-about .title-head' => 'color: {{VALUE}}',
              ],
            ]
          );
		  $this->add_control(
            'title_color_more',
            [
              'label' => __( 'title more', 'leora' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#212121',
              
              'selectors' => [
                '{{WRAPPER}} .product-introduction .content-introduction button a' => 'color: {{VALUE}}',
              ],
            ]
          );
		  $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'label' => __( 'Border', 'leora' ),
				'selector' => '{{WRAPPER}} .product-introduction .content-introduction button',
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$settings['background_color'] = $settings['background_color'] ?? '#fff';
		$settings['title_color'] = $settings['title_color'] ?? '#212121';

		$target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';
		?>
        <div class="container">
            <div class="product-introduction">
                <section style="background-color:<?php echo $settings['background_color'];?>">
                    <a style="float:<?php echo $settings['image_align']; ?>" href="<?php echo $settings['website_link']['url']; ?>" <?php echo $target . $nofollow ;?> class="box-img">
						<?php echo '<img src="' . $settings['image']['url'] . '">';?>
                    </a>
                    <div class="content-introduction post-content">
                        <h3 style="color:<?php echo $settings['title_color'];?>">
							<?php echo $settings['title'];?>
                        </h3>
                        <span>
							<?php echo $settings['item_description']; ?>
                        </span>
                        <?php if ($settings['title_more']):?>
                        <button>
                            <a href="<?php echo $settings['website_link']['url']; ?>" <?php echo $target . $nofollow ;?>>
                                <?php echo $settings['title_more']; ?>
                            </a>
                        </button>
                        <?php endif; ?>
                    </div>
                </section>
            </div>
        </div>
    <?php
	}
}