<?php

/**
 * Elementor Header Box Widget.
 *
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Typography;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Image_Size;


class Dimag_Sidbar extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'dimag-sidbar';
  }

  public function get_title()
  {
    return __(' sidbar', 'leora');
  }

  public function get_icon()
  {
    return 'eicon-sidebar';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }


  private function grid_get_all_post_type_categories($post_type)
  {
      $options = array();
  
      if ($post_type == 'post') {
          $taxonomy = 'category';
      } else {
          $taxonomy = 'product_cat';
      }
  
      // Get categories for post type.
      $terms = get_terms(
          array(
              'taxonomy' => $taxonomy,
              'hide_empty' => false,
          )
      );
  
      foreach ($terms as $term) {
          $options[$term->slug] = $term->name;
      }
  
      return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }

  private function wpcap_get_all_post_categories($post_type)
  {

      $options = array();

      $taxonomy = 'category';

      if (!empty($taxonomy)) {
          // Get categories for post type.
          $terms = get_terms(
              array(
                  'taxonomy'   => $taxonomy,
                  'hide_empty' => false,
              )
          );
          if (!empty($terms)) {
              foreach ($terms as $term) {
                  if (isset($term)) {
                      if (isset($term->slug) && isset($term->name)) {
                          $options[$term->slug] = $term->name;
                      }
                  }
              }
          }
      }

      return $options;
  }


      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
    $this->start_controls_section(
      'section_general',
      [
        'label' => __('general', 'leora'),
      ]
    );
    $this->add_control(
      'grid_style',
      [
        'label' => __('Grid Style', 'leora'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('Layout 1', 'leora'),
          '2' => esc_html__('Layout 2', 'leora'),
          '3' => esc_html__('Layout 3', 'leora'),
          '4' => esc_html__('Layout 4', 'leora'),
          '5' => esc_html__('Layout 5', 'leora'),
        ],
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more_two',
      [
        'label' => __(' مشاهده بیشتر', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'grid_style' => '4',
        ]
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('توضیحات', 'leora'),
        'type' => \Elementor\Controls_Manager::WYSIWYG,
        'default' => __('Default description', 'leora'),
        'placeholder' => __('Type your description here', 'leora'),
        'condition' => [
          'grid_style' => ['3','5'],
        ]
      ]
    );
    $this->add_control(
      'grid_post_type',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'leora'),
        'default' => 'post',
        'options' => $this->grid_get_all_post_types(),
      ]
    );
    $this->add_control(
      'grid_items',
      [
        'type'        => \Elementor\Controls_Manager::NUMBER,
        'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'leora'),
        'placeholder' => __('How many items?', 'leora'),
        'default'     => 14,
      ]
    );

    // Post categories.
    $this->add_control(
      'grid_post_categories',
      [
          'type'    => \Elementor\Controls_Manager::SELECT2,
          'label'   => '<i class="fa fa-folder"></i> ' . __('Categories', 'leora'),
          'options' => $this->grid_get_all_post_type_categories('post'),
          'multiple' => true, // Enable multi-selection.
          'condition' => [
              'grid_post_type' => 'post',
          ],
      ]
  );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'leora'),
        'label_off' => __('Hide', 'leora'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'leora'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'leora'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'grid_pagination',
      [
        'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __('Pagination', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => '',
      ]
    );
    // Order by.
    $this->add_control(
      'grid_order_by',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'leora'),
        'default' => 'date',
        'options' => [
          'date'          => __('Date', 'leora'),
          'title'         => __('Title', 'leora'),
          'modified'      => __('Modified date', 'leora'),
          'comment_count' => __('Comment count', 'leora'),
          'rand'          => __('Random', 'leora'),
        ],
      ]
    );

    // Price.
    $this->add_control(
      'grid_content_price',
      [
        'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'leora'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'section_grid.grid_post_type' => 'product',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'leora'),
      ]
    );
  $repeater = new \Elementor\Repeater();
  $repeater->add_control(
      'list_title',
      [
          'label' => __('Title', 'leora'),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => __('List Title', 'leora'),
          'label_block' => true,
      ]
  );
  $repeater->add_control(
      'title_more',
      [
          'label' => __('Title More', 'leora'),
          'type' => \Elementor\Controls_Manager::TEXT,
      ]
  );
  $repeater->add_control(
    'meta_data',
    [
        'label' => __('Meta Data', 'leora'),
        'label_block' => true,
        'type' => \Elementor\Controls_Manager::SELECT2,
        'default' => ['date', 'comments'],
        'multiple' => true,
        'options' => [
            'author' => __('Author', 'leora'),
            'date' => __('Date', 'leora'),
            'categories' => __('Categories', 'leora'),
            'comments' => __('Comments', 'leora'),
        ],
        'separator' => 'before',
    ]
);

$repeater->add_control(
    'meta_separator',
    [
        'label' => __('Separator Between', 'leora'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '/',
        'selectors' => [
            '{{WRAPPER}} .wpcap-grid-container .wpcap-post .post-grid-meta span + span:before' => 'content: "{{VALUE}}"',
        ],
        'condition' => [
            'meta_data!' => [],
        ],
    ]
);
$repeater->add_control(
    'posts_per_page',
    [
        'label' => __('Posts Per Page', 'leora'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'default' => 5,
    ]
);
// Post categories
$repeater->add_control(
    'post_categories',
    [
        'label'       => __('Categories', 'leora'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => $this->wpcap_get_all_post_categories('post'),

    ]
);

$repeater->add_control(
    'advanced',
    [
        'label' => __('Advanced', 'leora'),
        'type' => \Elementor\Controls_Manager::HEADING,
    ]
);

$repeater->add_control(
    'orderby',
    [
        'label' => __('Order By', 'leora'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'post_date',
        'options' => [
            'post_date' => __('Date', 'leora'),
            'post_title' => __('Title', 'leora'),
            'rand' => __('Random', 'leora'),
        ],
    ]
);

$repeater->add_control(
    'order',
    [
        'label' => __('Order', 'leora'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
            'asc' => __('ASC', 'leora'),
            'desc' => __('DESC', 'leora'),
        ],
    ]
);
  $repeater->add_control(
      'bg_image',
      [
          'label' => __('Choose Image background', 'leora'),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'dynamic' => [
              'active' => true,
          ],
          'default' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
      ]
  );
  $repeater->add_control(
    'bg_image_link',
    [
      'label' => __('Link', 'leora'),
      'type' => \Elementor\Controls_Manager::URL,
      'placeholder' => __('https://your-link.com', 'leora'),
      'show_external' => true,
      'default' => [
        'url' => '',
        'is_external' => true,
        'nofollow' => true,
      ],
    ]
  );
  $repeater->add_control(
      'image',
      [
          'label' => __('Choose Image', 'leora'),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
      ]
  );
  $repeater->add_control(
    'image_link',
    [
      'label' => __('Link', 'leora'),
      'type' => \Elementor\Controls_Manager::URL,
      'placeholder' => __('https://your-link.com', 'leora'),
      'show_external' => true,
      'default' => [
        'url' => '',
        'is_external' => true,
        'nofollow' => true,
      ],
    ]
  );
  $repeater->add_control(
      'Iconlayoutvid_list',
      [
          'label' => __('Icon', 'leora'),
          'type' => \Elementor\Controls_Manager::ICONS,
          'default' => [
              'value' => 'fas fa-star',
              'library' => 'solid',
          ],
      ]
  );

  $this->add_control(
      'list',
      [
          'label' => __('Repeater List', 'leora'),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'fields' => $repeater->get_controls(),
          'default' => [
              [
                  'list_title' => __('Title #1', 'leora'),
                  'list_content' => __('Item content. Click the edit button to change this text.', 'leora'),
              ],
              [
                  'list_title' => __('Title #2', 'leora'),
                  'list_content' => __('Item content. Click the edit button to change this text.', 'leora'),
              ],
          ],
          'title_field' => '{{{ list_title }}}',
      ]
  );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_style',
      [
        'label' => __('header ', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color',
      [
        'label' => __('background color', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#eee',
        
        'selectors' => [
          '{{WRAPPER}} .sidbar-1 .module-title h2,.sidbar-2 .module-title h2,.breaking_news__title a' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .sidbar-1 .module-title__sep,.sidbar-2 .module-title__sep' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style!' => '3',
        ]
      ]
    );
    $this->add_control(
      'title_color_show_more',
      [
        'label' => __('Title', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#6b7074',
        
        'selectors' => [
          '{{WRAPPER}} .breaking_news__title .news__title_text,.sidbar-1 .module-title h2.color_custom,.sidbar-2 .module-title h2.color_custom,h1.cb-module-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_mor',
      [
        'label' => __('Title More', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .breaking_news__title a' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style' => '4',
        ]
      ]
    );
    $this->add_control(
      'title_color_des',
      [
        'label' => __('description', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#212529',
        
        'selectors' => [
          '{{WRAPPER}} .widt-sidbar_3 .taxonomy-description' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style' => '3',
        ]
      ]
    );
    $this->add_control(
      'border_radius',
      [
        'label' => __( 'border radius', 'leora' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 5,
        ],
        'selectors' => [
          '{{WRAPPER}} .sidbar-1 .module-title h2.color_custom,.sidbar-2 .module-title h2.color_custom,.breaking_news__title a' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .widt-sidbar_5 .artic_list_arch' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
        ],
        'condition' => [
          'grid_style!' => '3',
        ]
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_1',
      [
        'label' => __('Page counter', 'leora'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'counter_active',
      [
        'label' => __('background color active', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fb3449',
        
        'selectors' => [
          '{{WRAPPER}} .pagenumbers span.current, .pagenumbers span:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter_text_active',
      [
        'label' => __('text active', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .pagenumbers span.current, .pagenumbers span:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter',
      [
        'label' => __('background color', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .pagenumbers a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter_text',
      [
        'label' => __('text', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#616161',
        
        'selectors' => [
          '{{WRAPPER}} .pagenumbers a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'border_radius_numbe',
      [
        'label' => __( 'border radius', 'leora' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 5,
        ],
        'selectors' => [
          '{{WRAPPER}} .pagenumbers a,.pagenumbers span.current' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_style_box',
      [
        'label' => __( 'box', 'leora' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow',
        'label' => esc_html__( 'Box Shadow', 'leora' ),
        'selector' => '{{WRAPPER}} .widt-sidbar_3 .solid-home a img,.content_item__cart__media__image,.content_item__cart__link,.topics-gallery__item',
        'condition' => [
          'grid_style!' => '4',
        ]
      ]
    );
    $this->add_control(
      'border_radius_article_5',
      [
        'label' => __( 'border radius', 'leora' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 5,
        ],
        'selectors' => [
          '{{WRAPPER}} .widt-sidbar_3 .title-category-header,.widt-sidbar_3 .solid-home a img,.widt-sidbar_3 .solid-home,.content_item__cart__media__image,.content_item__cart__link,.topics-gallery__item' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .breaking_news__item .breaking_news__header .breaking_news__image-box img' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .widt-sidbar_5 .adlist_them img,.widt-sidbar_5 .cardSuggestions' => 'border-radius: {{SIZE}}{{UNIT}}!important;',

        ],
      ]
    );
    $this->add_control(
      'background_Color_bookmark',
      [
        'label' => __('background Color', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .content_item__cart__detail__category ul li a' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .widt-sidbar_5 .card__bookmark,.widt-sidbar_5 .hed_title_arch::before' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style' => ['5','2'],
        ]
      ]
    );
    $this->add_control(
      'background_et_Color_bookmark',
      [
        'label' => __('text', 'leora'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .content_item__cart__detail__category ul li a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .widt-sidbar_5 .card__bookmark' => 'color: {{VALUE}}',
        ],
        'default' => '#fff',
        'condition' => [
          'grid_style' => ['5','2'],
        ]
      ]
    );
     $this->end_controls_section();
  }


  protected function render()
  {
    $settings = $this->get_settings();
    $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';

    $args = array();
    $grid_style = $settings['grid_style'];
    $args['post_status'] = 'publish';
    $args['ignore_sticky_posts'] = 1;
    if (!empty($settings['grid_post_type']) && post_type_exists($settings['grid_post_type'])) {
      $args['post_type'] = $settings['grid_post_type'];
    }
    if (!empty($settings['grid_post_categories']) && $settings['grid_post_type'] == 'post') {
      $args['category__in'] = array_map(function($slug) {
          $term = get_term_by('slug', $slug, 'category');
          return $term ? $term->term_id : null;
      }, $settings['grid_post_categories']);
  
      // Remove null values in case any term lookup failed.
      $args['category__in'] = array_filter($args['category__in']);
    }
    if (!empty($settings['grid_product_categories']) && $settings['grid_post_type'] == 'product') {
      $args['tax_query'] = array(
        'relation' => 'AND',
        array(
          'taxonomy' => 'product_cat',
          'field' => 'slug',
          'terms' => $settings['grid_product_categories'],
        ),
      );
    }
    if (!empty($settings['grid_items']) && intval($settings['grid_items']) == $settings['grid_items']) {
      $args['posts_per_page'] = $settings['grid_items'];
    }
    if (!empty($settings['grid_order_by'])) {
      $args['orderby'] = $settings['grid_order_by'];
    }
    if (!empty($settings['grid_pagination'])) {
      $paged         = get_query_var('paged');
      if (empty($paged)) {
        $paged         = get_query_var('page');
      }
      $args['paged'] = $paged;
    }
    $query = new \WP_Query($args);
    if ($query->have_posts()) {

      if (1 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-1.php');
      } elseif (2 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-2.php');
      } elseif (3 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-3.php');
      } elseif (4 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-4.php');
      } elseif (5 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-5.php');
      }
    } // end if; 

  }
}
