<?php

/**
 * Elementor Box Content Responsive Widget.
 *
 */

use \Elementor\Group_Control_Image_Size;


class Contact extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'contact';
  }

  public function get_title()
  {
    return __('تماس با ما', 'leora');
  }

  public function get_icon()
  {
    return 'eicon-form-horizontal';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }
      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
    $this->start_controls_section(
      'style_section_general',
       [
         'label' => __( 'general', 'leora' ),
         'tab' => \Elementor\Controls_Manager::TAB_STYLE,
       ]
     );
     $this->add_control(
      'background_color_contact',
      [
        'label' => __( 'background color', 'leora' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#ffff',
        
        'selectors' => [
          '{{WRAPPER}} .box-center-form' => 'background-color: {{VALUE}}!important;',
        ],
      ]
    );
    $this->add_control(
      'background_color_contact_button',
      [
        'label' => __( 'background color button', 'leora' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#E65353',
        
        'selectors' => [
          '{{WRAPPER}} .box-center-form .button' => 'background-color: {{VALUE}}!important;',
        ],
      ]
    );
    $this->add_control(
      'color_contact_button',
      [
        'label' => __( 'text color button', 'leora' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#ffff',
        
        'selectors' => [
          '{{WRAPPER}} .box-center-form .button' => 'color: {{VALUE}}!important;',
        ],
      ]
    );
     $this->add_control(
      'border_radius_contact',
      [
        'label' => __( 'border radius', 'leora' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 15,
        ],
        'selectors' => [
          '{{WRAPPER}} .box-center-form,.box-center-form input,box-center-form input.button,.box-center-form .text_p_form textarea' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
        ],
      ]
    );
    $this->add_control(
      'width_contact_box',
      [
        'label' => __( 'width', 'leora' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => '%',
          'size' => 50,
        ],
        'selectors' => [
          '{{WRAPPER}} .box-center-form' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  } 


  protected function render()
  {
    $settings = $this->get_settings(); ?>
    <div class="box-center-form">
      <form id="contactForm">
        <p class="form-row">
          <label for="contactName">نام شما:</label>
          <input type="text" name="contactName" id="contactName" value="" />
        </p>
        <p class="form-row">
          <label for="email">ایمیل شما:</label>
          <input type="text" name="email" id="email" value="" />
        </p>
        <p class="form-row text_p_form">
          <label for="commentsText">پیام:</label>
          <textarea name="commentsText" id="commentsText" rows="7" cols="30"></textarea>
        </p>
        <p class="form-row">
          <input class="button" type="submit" value="ارسال ایمیل"></input>
        </p>
        <input type="hidden" name="submitted" id="submitted" value="ارسال ایمیل" />
        <p id="status" class="form-row"></p>
      </form>
    </div>
<?php
  }
}
