<?php

/**
 * The template for displaying Comments
 *
 */
if (post_password_required()) {
	return;
}
function my_update_comment_fields($fields)
{

	$commenter = wp_get_current_commenter();
	$req       = get_option('require_name_email');
	$label     = $req ? '*' : ' ' . __('(optional)', 'leora');
	$aria_req  = $req ? "aria-required='true'" : '';
	$fields['author'] =
		'<p class="comment-form-author">
			<label for="author">' . __("Name", "leora") . $label . '</label>
			<input id="author" name="author" type="text" placeholder="' . esc_attr__("Jane Doe", "leora") . '" value="' . esc_attr($commenter['comment_author']) .
		'" size="30" ' . $aria_req . ' />
		</p>';

	$fields['email'] =
		'<p class="comment-form-email">
			<label for="email">' . __("Email", "leora") . $label . '</label>
			<input id="email" name="email" type="email" placeholder="' . esc_attr__("name@email.com", "leora") . '" value="' . esc_attr($commenter['comment_author_email']) .
		'" size="30" ' . $aria_req . ' />
		</p>';

	$fields['url'] =
		'<p class="comment-form-url">
			<label for="url">' . __("Website", "leora") . '</label>
			<input id="url" name="url" type="url"  placeholder="' . esc_attr__("http://google.com", "leora") . '" value="' . esc_attr($commenter['comment_author_url']) .
		'" size="30" />
			</p>';

	return $fields;
}
add_filter('comment_form_default_fields', 'my_update_comment_fields');
function my_update_comment_field($comment_field)
{

	$comment_field =
		'<p class="comment-form-comment">
			  <label for="comment">' . __("Comment", "leora") . '</label>
			  <textarea required id="comment" name="comment" placeholder="' . esc_attr__("Enter comment here...", "leora") . '" cols="45" rows="8" aria-required="true"></textarea>
		  </p>';

	return $comment_field;
}
add_filter('comment_form_field_comment', 'my_update_comment_field');
?>

<div id="comments" class="comments-area">

	<?php // You can start editing here -- including this comment! 
	?>
	<?php comment_form(); ?>

	<?php if (have_comments()) : ?>

		<ol class="commentlist">
			<?php
			wp_list_comments(
				array(
					'avatar_size' => 60,
					'max_depth'   => 5,
					'style'       => 'ol',
					'short_ping'  => true,
					'type'        => 'comment',
					'format'            => current_theme_supports('html5', 'comment-list') ? 'html5' : 'xhtml',
				)
			);
			?>
		</ol><!-- .commentlist -->

		<?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : // Are there comments to navigate through? 
		?>
			<nav id="comment-nav-below" class="navigation" role="navigation">
				<h1 class="assistive-text section-heading"><?php _e('Comment navigation', 'leora'); ?></h1>
				<div class="nav-previous"><?php previous_comments_link(__('&larr; Older Comments', 'leora')); ?></div>
				<div class="nav-next"><?php next_comments_link(__('Newer Comments &rarr;', 'leora')); ?></div>
			</nav>
		<?php endif; // Check for comment navigation. 
		?>

		<?php
		/*
		 * If there are no comments and comments are closed, let's leave a note.
		 * But we only want the note on posts and pages that had comments in the first place.
		 */
		if (!comments_open() && get_comments_number()) :
		?>
			<p class="nocomments"><?php _e('Comments are closed.', 'leora'); ?></p>
		<?php endif; ?>

	<?php endif; // have_comments() 
	?>
</div><!-- #comments .comments-area -->